using UnityEngine;

namespace hive.adkit.daro
{

	public class AdKitLogger
	{
		private static bool isUnityLogEnable = false;

		public static void SetUnityPluginLogEnable(bool isOn) {
			isUnityLogEnable = isOn;
		}

		public static void d(string message) {
			if(isUnityLogEnable) {
				Debug.Log(message);
			}
		}
		
		public static void d(string tag, string message) {
			if(isUnityLogEnable) {
				Debug.Log("[" + tag + "] " + message);
			}
		}

		public static void w(string message) {
			if(isUnityLogEnable) {
				Debug.LogWarning(message);
			}
		}
		
		public static void w(string tag, string message) {
			if(isUnityLogEnable) {
				Debug.LogWarning("[" + tag + "] " + message);
			}
		}

		public static void e(string message) {
			if(isUnityLogEnable) {
				Debug.LogError(message);
			}
		}
		
		public static void e(string tag, string message) {
			if(isUnityLogEnable) {
				Debug.LogError("[" + tag + "] " + message);
			}
		}
	}
}